#include "MojeOkno.h"
#include "Varia.h" //JednostkowyWektorNormalny3fv
#include "Modele.h" //Rysuj...
//#include "glext.h"
#include "resource.h"

#pragma region PDB
CMojeOknoGL::CMojeOknoGL()
:COknoGL(),pdb(NULL),
pokazujWiazania(true),pokazujPDB_rozmiar(1.00f),odswiezListyWyswietlania(false),
typRzutowania(false),
indeksWybranegoAtomu(-1)
{
	char* nazwaPliku=NULL;
	if(__argc>1) nazwaPliku=__argv[1];		
	else 
	{
		MessageBox(NULL,"Brak nazwy pliku w parametrze linii komend","Przegladarka PDB",MB_OK | MB_ICONWARNING);
		PostQuitMessage(0);
		return;
	}

	if (!OpenPDBFile(nazwaPliku)) PostQuitMessage(0);
}

CMojeOknoGL::~CMojeOknoGL()
{
	delete pdb;
	pdb=NULL;
}

#include <exception>

bool CMojeOknoGL::OpenPDBFile(const char* nazwaPliku)
{
	//plik podawany z parametru linii
    try
	{
		pdb=new PDB(nazwaPliku);        
	}
	catch(const std::exception& exc)
    {
		char komunikat[256]="Wystpi bd przy prbie zaadowania obiektu PDB:\n";
		strcat(komunikat,exc.what());
		MessageBox(uchwytOkna,komunikat,"Przegladarka PDB",MB_OK | MB_ICONERROR);
		return false;
    }

	return true;
}

void CMojeOknoGL::RysujPDB(PDB* pdb,const double jednostkaDlugosci,const double wielkoscAtomuWJednostkachDlugosci,bool koloruj) const
{
    if(pdb==NULL) return;

	glPushMatrix();

    //zero ukladu wspolrzednych w srodku masy	
    Wektor srodekMasy=jednostkaDlugosci*pdb->SrodekMasy();
    glTranslated(-srodekMasy.X,-srodekMasy.Y,-srodekMasy.Z);

	GLUquadricObj* kwadryka=gluNewQuadric();
	gluQuadricDrawStyle(kwadryka,GLU_FILL); 
	glShadeModel(GL_SMOOTH);

	const int ilePunktowWKazdymWymiarze=10; //jakosc sfery (moze byc zalezna np. od tego, czy trwa przeciaganie)
	
	glInitNames(); //tworzenie stosu nazw
	glPushName(-1); //kladzenie "pustego" elementu (nazwy) na stosie

    for(int indeks=0;indeks<pdb->LiczbaAtomow();indeks++)
    {
        Atom* atom=pdb->PobierzAtom(indeks);
        Wektor polozenieAtomu=jednostkaDlugosci*atom->Polozenie();
        
        //tu jest dobre miejsce na ewentalne filtrowanie rysowanych atomow

        if(koloruj) 
		{
			char symbolPierwiastka[3];
			Atom::WyodrebnijSymbolPierwiastka(atom->name,symbolPierwiastka);
			WybierzKolorAtomu(symbolPierwiastka,1.0f);
		}

		glPushMatrix();	
		glTranslated(polozenieAtomu.X,polozenieAtomu.Y,polozenieAtomu.Z);
		glLoadName(indeks); //zastepowanie nazwy z wierzchu stosu
		gluSphere(kwadryka,jednostkaDlugosci*wielkoscAtomuWJednostkachDlugosci,ilePunktowWKazdymWymiarze,ilePunktowWKazdymWymiarze);
		glPopMatrix();		
    }

	glPopName(); //usuwanie elementu ze stosu

	gluDeleteQuadric(kwadryka);
	glPopMatrix();
}


void CMojeOknoGL::RysujZaznaczonyAtom(PDB* pdb,const double jednostkaDlugosci,const double wielkoscAtomuWJednostkachDlugosci,int indeksWskazanegoAtomu,bool uzywajSiatki) const
{
	if (indeksWskazanegoAtomu<0) return;

	glPushMatrix();
	GLUquadricObj* kwadryka=gluNewQuadric();
	if(uzywajSiatki) gluQuadricDrawStyle(kwadryka,GLU_LINE);
	glLineWidth(1.0f);
	glShadeModel(GL_SMOOTH);	
	Wektor polozenieWskazanegoAtomu=jednostkaDlugosci*(pdb->PobierzAtom(indeksWskazanegoAtomu)->Polozenie()-pdb->SrodekMasy());
	glTranslated(polozenieWskazanegoAtomu.X,polozenieWskazanegoAtomu.Y,polozenieWskazanegoAtomu.Z);	
	gluSphere(kwadryka,jednostkaDlugosci*wielkoscAtomuWJednostkachDlugosci,15,15);
	gluDeleteQuadric(kwadryka);
	glPopMatrix();
}

void CMojeOknoGL::WyswietlOpisZaznaczonegoAtomu(int indeksWskazanegoAtomu,int czcionkaBitmapowa)
{
	char opisWybranegoAtomu[256]="";
	Atom* wybranyAtom=pdb->PobierzAtom(indeksWybranegoAtomu);
	_itoa(wybranyAtom->serial,opisWybranegoAtomu,10);
	strcat(opisWybranegoAtomu,". ");
	strcat(opisWybranegoAtomu,wybranyAtom->name);
	strcat(opisWybranegoAtomu," (");
	strcat(opisWybranegoAtomu,wybranyAtom->resName);
	strcat(opisWybranegoAtomu,")");
				
	glPushMatrix();
	glLoadIdentity();
	//napis umieszczony w lewym dolnym rogu			
	float wsp=wysokoscObszaruUzytkownika/(float)szerokoscObszaruUzytkownika;
	float wspolrzednaNapisu=(!typRzutowania)?-0.095f:-2.85f; //porownaj z parametrami frustum (argumenty wywolania glFrustum/glOrtho)
	glRasterPos3f(wspolrzednaNapisu,wspolrzednaNapisu*wsp,-0.3f); 
	Pisz(opisWybranegoAtomu,256,czcionkaBitmapowa,32);
	glPopMatrix();
}


void CMojeOknoGL::WybierzKolorAtomu(const char* symbolPierwiastka,const float alpha=1.0f) const
{
   switch(symbolPierwiastka[0]) //na razie tylko jednoliterowe
   {
      case 'C': glColor4f(0.25f,0.75f,0.75f,alpha); break;
      case 'O': glColor4f(1.00f,0.00f,0.00f,alpha); break;
      case 'H': glColor4f(1.00f,1.00f,1.00f,alpha); break;
      case 'N': glColor4f(0.00f,0.00f,1.00f,alpha); break;
      case 'P': glColor4f(0.50f,0.50f,0.20f,alpha); break;
      default: glColor4f(0.50f,0.50f,0.50f,alpha); break;
   }
}

void CMojeOknoGL::RysujWiazania(PDB* pdb,const double jednostkaDlugosci,bool koloruj) const
{	
    if(pdb==NULL) return;

	glPushMatrix();

    //zero ukladu wspolrzednych w srodku masy
    Wektor srodekMasy=jednostkaDlugosci*pdb->SrodekMasy();;
    glTranslated(-srodekMasy.X,-srodekMasy.Y,-srodekMasy.Z);

	glColor3f(0,0,0);
	glColorMaterial(GL_FRONT_AND_BACK,GL_AMBIENT);

	glShadeModel(GL_SMOOTH);
	glLineWidth(2);
	glBegin(GL_LINES); 
    for(int indeks1=0;indeks1<pdb->LiczbaAtomow();indeks1++)
		for(int indeks2=indeks1+1;indeks2<pdb->LiczbaAtomow();indeks2++)
		{
			Atom* atom1=pdb->PobierzAtom(indeks1);
			Atom* atom2=pdb->PobierzAtom(indeks2);
			Wektor polozenieAtomu1=jednostkaDlugosci*atom1->Polozenie();
			Wektor polozenieAtomu2=jednostkaDlugosci*atom2->Polozenie();
			Wektor polozenie12=polozenieAtomu2-polozenieAtomu1;

			if(polozenie12.Dlugosc()<0.17) //w AA
			{
				if(koloruj) 
				{
					char symbolPierwiastka[3];
					Atom::WyodrebnijSymbolPierwiastka(atom1->name,symbolPierwiastka);
					WybierzKolorAtomu(symbolPierwiastka,1.0f);
				}
				glVertex3d(polozenieAtomu1.X,polozenieAtomu1.Y,polozenieAtomu1.Z);
				if(koloruj) 
				{
					char symbolPierwiastka[3];
					Atom::WyodrebnijSymbolPierwiastka(atom2->name,symbolPierwiastka);
					WybierzKolorAtomu(symbolPierwiastka,1.0f);
				}
				glVertex3d(polozenieAtomu2.X,polozenieAtomu2.Y,polozenieAtomu2.Z);
			}
    }
	glEnd();

	glColorMaterial(GL_FRONT_AND_BACK,GL_AMBIENT_AND_DIFFUSE);	

	glPopMatrix();
}

//lista wyswietlania
unsigned int CMojeOknoGL::TworzListyWyswietlania(const double jednostkaDlugosci) const
{	
	GLuint listyWyswietlania=glGenLists(1);

	glNewList(listyWyswietlania,GL_COMPILE);
	glColor3f(1,1,1);
	if(pokazujWiazania) RysujWiazania(pdb,jednostkaDlugosci,true);	
	if(pokazujPDB_rozmiar!=0) RysujPDB(pdb,jednostkaDlugosci,pokazujPDB_rozmiar,true);
	glEndList();

	return listyWyswietlania;
}

LRESULT CMojeOknoGL::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{	
	long wynik=COknoGL::WndProc(hWnd,message,wParam,lParam);

	switch (message)
	{
		case WM_KEYDOWN:
			{
				bool wywolacRysujScene=false;
				switch(wParam)
				{
					case VK_F1:
						MessageBox(uchwytOkna,"Klawisze skrtu:\nZ - pokazywanie/ukrywanie wiza\nX - rozmiar atomw\nC - tryb rzutowania","Przegldarka PDB",MB_OK);
						break;
					case 'Z':
						pokazujWiazania=!pokazujWiazania;
						wywolacRysujScene=true;
						break;
					case 'X':
						{
							float nowyRozmiar=-1.0f;
							if (pokazujPDB_rozmiar==0.0f) nowyRozmiar=0.25f; 
							if (pokazujPDB_rozmiar==0.25f) nowyRozmiar=0.5f;
							if (pokazujPDB_rozmiar==0.5f) nowyRozmiar=1.0f; 
							if (pokazujPDB_rozmiar==1.0f) nowyRozmiar=0.0f; 
							if (nowyRozmiar==-1.0f) nowyRozmiar=1.0f;
							pokazujPDB_rozmiar=nowyRozmiar;
						}
						wywolacRysujScene=true;
						break;
					case 'C':
						typRzutowania=!typRzutowania;
						UstawienieSceny(typRzutowania);
						wywolacRysujScene=true;
						break;
				}
				if (wywolacRysujScene)
				{
					odswiezListyWyswietlania=true;
					RysujScene();
				}
				break;
			}
		case WM_LBUTTONDOWN:
			if(pokazujPDB_rozmiar==0) break;			
			POINT pozycjaKursoraMyszy;
			pozycjaKursoraMyszy.x=LOWORD(lParam);
			pozycjaKursoraMyszy.y=HIWORD(lParam);			

			int poprzedniIndeks=indeksWybranegoAtomu;
			int nowyIndeks=WyborAtomu(pozycjaKursoraMyszy);
			if (nowyIndeks!=-1) indeksWybranegoAtomu=nowyIndeks;
			if(poprzedniIndeks!=-1 || indeksWybranegoAtomu!=-1) 
				RysujScene();
			break;
	}
	
	return wynik;
}

//selekcja
int CMojeOknoGL::WyborAtomu(POINT pozycjaKursoraMyszy)
{
	//przygotowanie bufora zaznaczania
	const int rozmiarBuforaZaznaczania=1024;
	unsigned int buforZaznaczania[rozmiarBuforaZaznaczania];
	ZeroMemory(buforZaznaczania,rozmiarBuforaZaznaczania);
	glSelectBuffer(rozmiarBuforaZaznaczania,buforZaznaczania);

	//przygotowanie promienia pod myszka = b. waskie frustum
	//niestety powtorzenie kodu z COknoGL::UstawienieSceny
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	//przez ta funkcje nie mozna po prostu wywolac metody UstawienieSceny (mozna ja tam wstrzyknac, ale wowczas zamieszanie w tekscie)
	int viewport[4];
	glGetIntegerv(GL_VIEWPORT,viewport);
	gluPickMatrix(pozycjaKursoraMyszy.x,wysokoscObszaruUzytkownika-pozycjaKursoraMyszy.y,1,1,viewport);
	float wsp=wysokoscObszaruUzytkownika/(float)szerokoscObszaruUzytkownika;
	if(!typRzutowania)
		//left,right,bottom,top,znear,zfar (clipping) 	
		//mnozenie macierzy rzutowania przez macierz perspektywy - ustalanie frustum 	
		glFrustum(-0.1, 0.1, wsp*-0.1, wsp*0.1, 0.3, 100.0); 
	else
		glOrtho(-3, 3, wsp*-3, wsp*3, 0.3, 100.0); //ZLE DZIALA Z glOrtho
	
	glMatrixMode(GL_MODELVIEW);
	
	//przelaczenie w tryb selekcji i renderowanie sceny
	glRenderMode(GL_SELECT); //zakomentuj to polecenie, zeby zobaczyc co "widzi" myszka
	RysujScene();

	//powrot do normalnego trybu renderowania
	int ileTrafien=glRenderMode(GL_RENDER);
	//int nrBledu=glGetError();

	//przywracanie oryginalnej macierzy rzutowania
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();

	glMatrixMode(GL_MODELVIEW);
	
	/*
	char bufor[256];
	_itoa(ileTrafien,bufor,10);
	SetWindowText(uchwytOkna,bufor);	
	*/	

	//interpretacja zawartosci bufora zaznaczania
	if(ileTrafien>0) 
	{
		//zwracam obiekt najblizszy kamery
		unsigned int indeksNajblizszegoAtomu=buforZaznaczania[3];		
		unsigned int odlegloscNajblizszegoAtomu=buforZaznaczania[1];
		int biezacyIndeks=0;
		for(int i=0;i<ileTrafien;i++)
		{			
			if(buforZaznaczania[biezacyIndeks+1]<odlegloscNajblizszegoAtomu) 
			{				
				odlegloscNajblizszegoAtomu=buforZaznaczania[biezacyIndeks+1];
				if(buforZaznaczania[biezacyIndeks]>0) indeksNajblizszegoAtomu=buforZaznaczania[biezacyIndeks+3]; //zdaza sie, ze ilosc nazw=0; w naszym przypadku moze byc tylko jedna nazwa w trafieniu
			}
			biezacyIndeks+=3+buforZaznaczania[biezacyIndeks]; //ilosc nazw,z_min,z_max i nazwy (w ilosci zadanej przez ilosc nazw)
		}
		//SetWindowText(uchwytOkna,pdb->PobierzAtom(indeksNajblizszegoAtomu)->pdbRecord);
		return indeksNajblizszegoAtomu;
	}
	else return -1;
}
#pragma endregion

void CMojeOknoGL::RysujAktorow()
{	
	WyswietlCzestoscRenderowania();

	const double jednostkaDlugosci=0.1;

	//tworzenie list wyswietlania
	static GLuint listyWyswietlania=NULL;	
	if(!glIsList(listyWyswietlania) || odswiezListyWyswietlania)
	{
		if(odswiezListyWyswietlania) glDeleteLists(listyWyswietlania,1);
		listyWyswietlania=TworzListyWyswietlania(jednostkaDlugosci);
		odswiezListyWyswietlania=false;
	}

	//tworzenie czcionki bitmapowej	
	static unsigned int czcionkaBitmapowa=NULL;
	if (czcionkaBitmapowa==NULL)
      czcionkaBitmapowa=StworzCzcionke(false,uchwytOkna,"Times",
                                       20,false,false,32,255);	

	//RysujWiazania(pdb,jednostkaDlugosci,true);	
	//RysujPDB(pdb,jednostkaDlugosci,1,true);
	glCallList(listyWyswietlania);	
	int trybRenderowania=0;
	glGetIntegerv(GL_RENDER_MODE,&trybRenderowania);
	if(trybRenderowania==GL_RENDER)
	{
		if(indeksWybranegoAtomu>=0 && pokazujPDB_rozmiar>0) 
		{
			glColor3f(1,1,0);
			RysujZaznaczonyAtom(pdb,jednostkaDlugosci,1.05*pokazujPDB_rozmiar,indeksWybranegoAtomu,false);		
			glColor3f(3,3,3); //jasniejszy niz bialy!
			WyswietlOpisZaznaczonegoAtomu(indeksWybranegoAtomu,czcionkaBitmapowa);
		}
	}	
}

#pragma region Zrodla swiatla
//zrodla swiatla
void CMojeOknoGL::ZrodlaSwiatla()
{
	natezenie_swiatla_tla=0.5f;
	MlecznaZarowka(0.5f);
	
	/*
	//mgla
	glEnable(GL_FOG);
	const float biel[4]={1.0,1.0,1.0,1.0};
	glFogfv(GL_FOG_COLOR,biel);
	glFogf(GL_FOG_START,0.0);
	glFogf(GL_FOG_END,100.0);
	glFogf(GL_FOG_MODE,GL_LINEAR);
	*/	
}


void CMojeOknoGL::MlecznaZarowka(float jasnosc)
{	
	const float kolor[4]={jasnosc,jasnosc,jasnosc,1.0f};
	const float pozycja[4]={5.0f,0.0f,5.0f,1.0f};	
	glLightfv(GL_LIGHT1,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor);
	glEnable(GL_LIGHT1);
}

void CMojeOknoGL::ZoltaIZielonaMleczneZarowki()
{
	//zolta mleczna zarowka
	const float kolor_zolta[4]={1.0f,1.0f,0.0f,1.0f};
	const float pozycja_zolta[4]={-2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT2,GL_POSITION,pozycja_zolta);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_zolta);
	//glEnable(GL_LIGHT2);

	//zielona mleczna zarowka
	const float kolor_zielony[4]={0.0f,1.0f,0.0f,1.0f};
	const float pozycja_zielony[4]={2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT3,GL_POSITION,pozycja_zielony);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor_zielony);
	//glEnable(GL_LIGHT3);
}

void CMojeOknoGL::Reflektor(float jasnoscRozblysk,float jasnoscRozproszone)
{
	const float kolor_rozproszone[4]={jasnoscRozproszone,jasnoscRozproszone,jasnoscRozproszone,1.0f};
	const float kolor_rozblysk[4]={jasnoscRozblysk,jasnoscRozblysk,jasnoscRozblysk,1.0};
	const float pozycja[4]={-10.0f,-10.0f,10.0f,1.0f};	
	const float kierunek[4]={1.0,1.0,-1.0,1.0};   
	const float szerokosc_wiazki=30.0f; //w stopniach
	const float wygaszanie=1.0f;
   
	glLightfv(GL_LIGHT4,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT4,GL_DIFFUSE,kolor_rozproszone);

	glLightfv(GL_LIGHT4,GL_SPECULAR,kolor_rozblysk);
	glLightfv(GL_LIGHT4,GL_SPOT_DIRECTION,kierunek);
	glLightf(GL_LIGHT4,GL_SPOT_CUTOFF,szerokosc_wiazki);
	glLightf(GL_LIGHT4,GL_SPOT_EXPONENT,wygaszanie);
	//glEnable(GL_LIGHT4);
}
#pragma endregion

